/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IRemoteConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public class SerialConnection
implements IRemoteConnection {
    private static final int PORT_OPEN_TIMEOUT = 1000;
    private SerialPort m_serialPort = null;
    private String m_portName;
    private boolean m_isConnected;
    private int m_baudRate;

    public SerialConnection(String portName) {
        this.m_portName = portName;
        this.m_isConnected = false;
        this.m_baudRate = 9600;
    }

    public SerialConnection(String portName, int baudRate) {
        this.m_portName = portName;
        this.m_isConnected = false;
        this.m_baudRate = baudRate;
    }

    public String getName() {
        return this.m_portName;
    }

    public boolean isEchoing() {
        return true;
    }

    public String getEndOfResponse() {
        return "\r\n\r\n";
    }

    public String getEndOfPrompt() {
        return ">";
    }

    public void connect() throws Exception {
        if (this.m_isConnected) {
            return;
        }
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)this.m_portName);
        this.m_serialPort = (SerialPort)portId.open("CECTester", 1000);
        this.m_serialPort.setSerialPortParams(this.m_baudRate, 8, 1, 0);
        this.m_serialPort.enableReceiveTimeout(3000);
        this.m_isConnected = true;
    }

    public void disconnect() throws Exception {
        if (!this.m_isConnected) {
            return;
        }
        this.m_isConnected = false;
        this.m_serialPort.close();
        this.m_serialPort = null;
    }

    public boolean isConnected() {
        return this.m_isConnected;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_serialPort.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.m_serialPort.getInputStream();
    }

    public IRemoteConnection getAlternateChannel() {
        return null;
    }

    public static String[] getAvailablePortNames() {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        Vector<CommPortIdentifier> ids = new Vector<CommPortIdentifier>();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (!portId.getName().substring(0, 3).equals("COM")) continue;
            ids.add(portId);
        }
        String[] names = new String[ids.size()];
        int i = 0;
        while (i < ids.size()) {
            CommPortIdentifier port = (CommPortIdentifier)ids.get(i);
            names[i] = port.getName();
            ++i;
        }
        return names;
    }

    public void setBaudRate(int rate) {
        this.m_baudRate = rate;
    }

    public int getBaudRate() {
        return this.m_baudRate;
    }

    public String getErrorMessage() {
        return "";
    }
}

